var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
//
// Copyright (C) Microsoft. All rights reserved.
//
//--------
// External CommonMerged references.  These are included explicitly in the csproj
// as the CommonMerged.d.ts is generated at build-time.
// If we reference them here, TSC 1.8.10 includes the source in the merged JS file
// which is not what we want.
//--------
// <reference path="../../Common/Controls/templateControl.ts" />
// <reference path="../../Common/Util/formattingHelpers.ts" />
// <reference path="../../Common/controls/componentModel.ts" />
// <reference path="../../Common/Profiler/Snapshot.ts" />
//--------
/// <reference path="../../../../../common/script/Hub/plugin.redirect.d.ts" />
var MemoryProfiler;
(function (MemoryProfiler) {
    "use strict";
    var SnapshotTileViewModel = (function () {
        function SnapshotTileViewModel(summary) {
            this._summary = summary;
        }
        Object.defineProperty(SnapshotTileViewModel.prototype, "summaryData", {
            get: function () {
                return this._summary;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotTileViewModel.prototype, "timeTaken", {
            get: function () {
                var date = new Date(this._summary.timestamp);
                return "(" + date.toLocaleTimeString() + ")";
            },
            enumerable: true,
            configurable: true
        });
        return SnapshotTileViewModel;
    }());
    MemoryProfiler.SnapshotTileViewModel = SnapshotTileViewModel;
    var SnapshotTileView = (function (_super) {
        __extends(SnapshotTileView, _super);
        function SnapshotTileView(model) {
            _super.call(this, "SnapshotTileTemplate");
            this._model = model;
            this._snapshotTile = this.findElement("snapshotTile");
            this._tileHeader = this.findElement("snapshotTileHeader");
            this._screenshotNotAvailableMessage = this.findElement("screenshotNotAvailableMessage");
            this.findElement("snapshotTileTitle").innerText = Microsoft.Plugin.Resources.getString("SnapshotNumber", this._model.summaryData.id);
            if (this._model.summaryData.screenshotFile) {
                var imgHolder = this.findElement("snapshotTileImage");
                imgHolder.src = this._model.summaryData.screenshotFile;
                this._screenshotNotAvailableMessage.style.display = "none";
            }
            this.findElement("snapshotTakenDate").innerText = this._model.timeTaken;
            this.findElement("stopToSeeSnapshotDetails").innerText = Microsoft.Plugin.Resources.getString("StopToSeeSnapshotMessage");
            this._screenshotNotAvailableMessage.innerText = Microsoft.Plugin.Resources.getString("ScreenshotNotAvailable");
        }
        return SnapshotTileView;
    }(MemoryProfiler.Common.Controls.TemplateControl));
    MemoryProfiler.SnapshotTileView = SnapshotTileView;
})(MemoryProfiler || (MemoryProfiler = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
//--------
// External CommonMerged references.  These are included explicitly in the csproj
// as the CommonMerged.d.ts is generated at build-time.
// If we reference them here, TSC 1.8.10 includes the source in the merged JS file
// which is not what we want.
//--------
// <reference path="../../../../../common/script/util/notifications.ts" />
// <reference path="../../common/controls/componentModel.ts" />
// <reference path="../../common/controls/templateControl.ts" />
// <reference path="../../common/util/EnumHelper.ts" />
// <reference path="../../common/Profiler/MemoryNotifications.ts" />
// <reference path="../../common/util/errorFormatter.ts" />
// <reference path="../../common/Profiler/MemoryProfilerViewHost.ts" />
// <reference path="../../common/Profiler/SnapshotEngine.ts" />
// <reference path="../../common/Profiler/ClrSnapshotAgent.ts" />
// <reference path="../../common/Profiler/ScreenshotSnapshotAgent.ts" />
// <reference path="../../common/Profiler/FeedbackConstants.ts" />
//--------
/// <reference path="../../../../../common/script/Hub/Plugin.redirect.d.ts" />
/// <reference path="../../../../../common/script/Hub/DiagnosticsHub.redirect.d.ts" />
/// <reference path="CollectionAgentTask.ts" />
/// <reference path="snapshotTileView.ts" />
var MemoryProfiler;
(function (MemoryProfiler) {
    "use strict";
    var CollectionViewController = (function () {
        function CollectionViewController(initializeView) {
            var _this = this;
            if (initializeView === void 0) { initializeView = true; }
            this._screenshotHeight = 150;
            this._screenshotKeepAspectRatio = true;
            this._screenshotWidth = 200;
            this._agentGuid = "2E8E6F4B-6107-4F46-8BEA-A920EA880452"; // This is the guid of MemoryProfilerCollectionAgent
            this._activeCollectionAgentTasks = [];
            this.model = new CollectionViewModel();
            if (initializeView) {
                this.view = new CollectionView(this, this.model);
            }
            this._takeSnapshotTask = new MemoryProfiler.TakeSnapshotTask(this);
            this._forceGcTask = new MemoryProfiler.ForceGcCollectionAgentTask(this);
            MemoryProfiler.Common.MemoryProfilerViewHost.session.getSessionInfo().then(function (info) {
                _this._agentGuid = info.agentGuid;
                _this._standardCollector = Microsoft.VisualStudio.DiagnosticsHub.Collectors.getStandardTransportService();
                if (_this._standardCollector) {
                    _this._standardCollector.addMessageListener(new Microsoft.VisualStudio.DiagnosticsHub.Guid(_this._agentGuid), _this.onMessageReceived.bind(_this));
                }
            });
        }
        Object.defineProperty(CollectionViewController.prototype, "isCollectionAgentTaskActive", {
            get: function () {
                return this._activeCollectionAgentTasks.length > 0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CollectionViewController.prototype, "managedDataSeen", {
            get: function () {
                return this._managedDataSeen;
            },
            set: function (v) {
                this._managedDataSeen = v;
            },
            enumerable: true,
            configurable: true
        });
        CollectionViewController.prototype.takeSnapshot = function () {
            this._activeCollectionAgentTasks.push(this._takeSnapshotTask);
            return this._takeSnapshotTask.start();
        };
        CollectionViewController.prototype.forceGarbageCollection = function () {
            this._activeCollectionAgentTasks.push(this._forceGcTask);
            return this._forceGcTask.start();
        };
        CollectionViewController.prototype.setScreenshotSize = function (targetWidth, targetHeight, keepAspectRatio) {
            // Set the size of all future screenshots that are taken of the application
            this._screenshotWidth = targetWidth;
            this._screenshotHeight = targetHeight;
            this._screenshotKeepAspectRatio = keepAspectRatio;
        };
        CollectionViewController.prototype.reset = function () {
            CollectionViewController._nextIdentifier = 1;
            this.model.snapshotSummaryCollection.clear();
            MemoryProfiler.Common.MemoryProfilerViewHost.onIdle();
        };
        CollectionViewController.prototype.sendStringToCollectionAgent = function (request) {
            return this._standardCollector.sendStringToCollectionAgent(this._agentGuid, request);
        };
        CollectionViewController.prototype.downloadFile = function (targetFilePath, localFilePath) {
            var transportService = Microsoft.VisualStudio.DiagnosticsHub.Collectors.getStandardTransportService();
            return transportService.downloadFile(targetFilePath, localFilePath);
        };
        CollectionViewController.prototype.getSnapshotSummary = function (snapshotId) {
            var foundSnapshotSummary = null;
            for (var i = 0; i < this.model.snapshotSummaryCollection.length; i++) {
                var snapshotSummary = this.model.snapshotSummaryCollection.getItem(i);
                if (snapshotSummary.id === snapshotId) {
                    foundSnapshotSummary = snapshotSummary;
                    break;
                }
            }
            return foundSnapshotSummary;
        };
        CollectionViewController.prototype.onMessageReceived = function (message) {
            if (message) {
                var obj = JSON.parse(message);
                if (obj) {
                    if (obj.eventName) {
                        switch (obj.eventName) {
                            case "notifyManagedPresent":
                                this.managedDataSeen = true;
                                MemoryProfiler.Common.MemoryProfilerViewHost.session.getSessionInfo().then(function (info) {
                                    if (info.targetRuntime === MemoryProfiler.Common.Extensions.TargetRuntime.managed || info.targetRuntime === MemoryProfiler.Common.Extensions.TargetRuntime.mixed) {
                                        MemoryProfiler.CollectionViewHost.CommandChain.onTargetIsManaged();
                                    }
                                });
                                break;
                            default:
                                break;
                        }
                    }
                    else if (obj.cmd) {
                        switch (obj.cmd) {
                            case "log":
                                MemoryProfiler.Common.MemoryProfilerViewHost.logMessage(obj.msg);
                                break;
                            default:
                                MemoryProfiler.Common.MemoryProfilerViewHost.logMessage("Unexpected Command from agent: " + message);
                                break;
                        }
                        return; // Commands are not passed on to active tasks - eventName messages (and everything else) are.
                    }
                }
            }
            for (var i = this._activeCollectionAgentTasks.length - 1; i >= 0; i--) {
                if (this._activeCollectionAgentTasks[i].isCompleted(message)) {
                    this._activeCollectionAgentTasks.splice(i, 1);
                }
            }
        };
        CollectionViewController.prototype.sendMessage = function (message) {
            this._standardCollector.sendStringToCollectionAgent(this._agentGuid, message).done(function (response) {
                if (response && response.length > 0) {
                    var obj = JSON.parse(response);
                    if (!obj.succeeded) {
                        throw new Error(obj.errorMessage);
                    }
                }
            });
        };
        CollectionViewController._snapshotChunkSize = 32768;
        CollectionViewController._nextIdentifier = 1;
        return CollectionViewController;
    }());
    MemoryProfiler.CollectionViewController = CollectionViewController;
    var CollectionViewModel = (function (_super) {
        __extends(CollectionViewModel, _super);
        function CollectionViewModel() {
            _super.call(this);
            this._warningMessage = "";
            this._latestSnapshotError = null;
            this._isTakingSnapshot = false;
            this._isForcingGarbageCollection = false;
            this._snapshotSummaryCollection = new MemoryProfiler.Common.Controls.ObservableCollection();
        }
        Object.defineProperty(CollectionViewModel.prototype, "snapshotSummaryCollection", {
            get: function () { return this._snapshotSummaryCollection; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CollectionViewModel.prototype, "warningMessage", {
            get: function () { return this._warningMessage; },
            set: function (v) {
                if (this._warningMessage !== v) {
                    this._warningMessage = v;
                    this.raisePropertyChanged("warningMessage");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CollectionViewModel.prototype, "latestSnapshotError", {
            get: function () { return this._latestSnapshotError; },
            set: function (v) {
                if (this._latestSnapshotError !== v) {
                    this._latestSnapshotError = v;
                    this.raisePropertyChanged("latestSnapshotError");
                    // Create the WER
                    MemoryProfiler.Common.MemoryProfilerViewHost.reportError(v, "SnapshotCapturingFailure");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CollectionViewModel.prototype, "isTakingSnapshot", {
            get: function () { return this._isTakingSnapshot; },
            set: function (v) {
                if (this._isTakingSnapshot !== v) {
                    this._isTakingSnapshot = v;
                    this.raisePropertyChanged("isTakingSnapshot");
                    this.raisePropertyChanged("isViewBusy");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CollectionViewModel.prototype, "isForcingGarbageCollection", {
            get: function () { return this._isForcingGarbageCollection; },
            set: function (v) {
                if (this._isForcingGarbageCollection !== v) {
                    this._isForcingGarbageCollection = v;
                    this.raisePropertyChanged("isForcingGarbageCollection");
                    this.raisePropertyChanged("isViewBusy");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CollectionViewModel.prototype, "isViewBusy", {
            get: function () { return this._isForcingGarbageCollection || this._isTakingSnapshot; },
            enumerable: true,
            configurable: true
        });
        return CollectionViewModel;
    }(MemoryProfiler.Common.Controls.ObservableViewModel));
    MemoryProfiler.CollectionViewModel = CollectionViewModel;
    var CollectionView = (function (_super) {
        __extends(CollectionView, _super);
        function CollectionView(controller, model) {
            _super.call(this, "CollectionViewTemplate");
            this._screenshotWidth = 280;
            this._screenshotHeight = 160;
            this._screenshotKeepAspectRatio = true;
            this._controller = controller;
            this._model = model;
            this.rootElement.classList.add("collectionViewRoot");
            this._model.registerPropertyChanged(this);
            this._model.snapshotSummaryCollection.registerCollectionChanged(this);
            this._snapshotTileViewModelCollection = [];
            this._tilesContainer = this.findElement("tilesContainer");
            this._warningSection = this.findElement("warningSection");
            this._onSnapshotClickHandler = this.onSnapshotClick.bind(this);
            this._takeSnapshotTile = this.findElement("takeSnapshotTile");
            this._snapshotError = this.findElement("snapshotError");
            this._snapshotErrorMsg = this.findElement("snapshotErrorMsg");
            this._snapshotProgress = this.findElement("takeSnapshotProgress");
            this._snapshotButton = this.findElement("takeSnapshotButton");
            this._snapshotLabel = this.findElement("takeSnapshotLabel");
            this._snapshotIcon = this.findElement("takeSnapshotIcon");
            this._snapshotLabel.innerText = Microsoft.Plugin.Resources.getString("TakeSnapshot");
            this._snapshotProgress.innerText = Microsoft.Plugin.Resources.getString("Loading");
            this.toggleProgress(this._model.isViewBusy);
            this.updateTakeSnapshotButton();
            this._snapshotButton.addEventListener("click", this._onSnapshotClickHandler);
            this._controller.setScreenshotSize(this._screenshotWidth, this._screenshotHeight, this._screenshotKeepAspectRatio);
            Microsoft.Plugin.Theme.processInjectedSvg(this.rootElement);
        }
        Object.defineProperty(CollectionView.prototype, "snapshotTileViewModelCollection", {
            get: function () {
                return this._snapshotTileViewModelCollection;
            },
            enumerable: true,
            configurable: true
        });
        CollectionView.prototype.onPropertyChanged = function (propertyName) {
            switch (propertyName) {
                case "warningMessage":
                    this.showWarningMessage(this._model.warningMessage);
                    break;
                case "latestSnapshotError":
                    this.showSnapshotError(this._model.latestSnapshotError);
                    break;
                case "isTakingSnapshot":
                    this.toggleProgress(this._model.isViewBusy);
                    this.updateTakeSnapshotButton();
                    break;
                case "isForcingGarbageCollection":
                    this.updateTakeSnapshotButton();
                    break;
            }
        };
        CollectionView.prototype.onCollectionChanged = function (eventArgs) {
            switch (eventArgs.action) {
                case MemoryProfiler.Common.Controls.NotifyCollectionChangedAction.Add:
                    this.createTile(eventArgs.newItems[0]);
                    break;
                case MemoryProfiler.Common.Controls.NotifyCollectionChangedAction.Reset:
                    this.removeSnapshotTiles();
                    break;
            }
        };
        CollectionView.prototype.createTile = function (snapshotSummary) {
            // Create the model and the view
            var model = new MemoryProfiler.SnapshotTileViewModel(snapshotSummary);
            var newTile = new MemoryProfiler.SnapshotTileView(model);
            this._snapshotTileViewModelCollection.push(model);
            this._tilesContainer.insertBefore(newTile.rootElement, this._takeSnapshotTile);
            newTile.rootElement.focus();
        };
        CollectionView.prototype.removeSnapshotTiles = function () {
            while (this._tilesContainer.hasChildNodes()) {
                this._tilesContainer.removeChild(this._tilesContainer.firstChild);
            }
            this._tilesContainer.appendChild(this._takeSnapshotTile);
            this._snapshotTileViewModelCollection = [];
        };
        CollectionView.prototype.toggleProgress = function (show) {
            if (this._snapshotProgress && this._snapshotError) {
                if (show) {
                    this._snapshotLabel.style.display = "none";
                    this._snapshotIcon.style.display = "none";
                    this._snapshotProgress.style.display = "block";
                    this._snapshotError.style.display = "none";
                    this._snapshotButton.setAttribute("aria-label", Microsoft.Plugin.Resources.getString("Loading"));
                }
                else {
                    this._snapshotLabel.style.display = "";
                    this._snapshotIcon.style.display = "";
                    this._snapshotProgress.style.display = "none";
                    this._snapshotButton.setAttribute("aria-label", Microsoft.Plugin.Resources.getString("TakeSnapshot"));
                }
            }
        };
        CollectionView.prototype.showSnapshotError = function (error) {
            if (this._snapshotErrorMsg && this._snapshotError) {
                if (error) {
                    // Show the message
                    this._snapshotErrorMsg.innerText = MemoryProfiler.Common.ErrorFormatter.format(error);
                    this._snapshotError.style.display = "block";
                }
                else {
                    // Hide the message
                    this._snapshotErrorMsg.innerText = "";
                    this._snapshotError.style.display = "none";
                }
            }
        };
        CollectionView.prototype.showWarningMessage = function (warning) {
            if (!this._warningSection) {
                return;
            }
            if (warning) {
                this._warningSection.innerHTML = warning;
                this._warningSection.style.display = "inline";
            }
            else {
                this._warningSection.innerHTML = "";
                this._warningSection.style.display = "none";
            }
        };
        CollectionView.prototype.onSnapshotClick = function (e) {
            this._controller.takeSnapshot();
        };
        CollectionView.prototype.updateTakeSnapshotButton = function () {
            if (this._snapshotButton) {
                if (!this._model.isViewBusy) {
                    this._snapshotButton.classList.remove("disabled");
                    this._snapshotButton.disabled = false;
                }
                else {
                    if (this._model.isForcingGarbageCollection)
                        this._snapshotButton.classList.add("disabled");
                    this._snapshotButton.disabled = true;
                }
            }
        };
        return CollectionView;
    }(MemoryProfiler.Common.Controls.TemplateControl));
    MemoryProfiler.CollectionView = CollectionView;
})(MemoryProfiler || (MemoryProfiler = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
//--------
// External CommonMerged references.  These are included explicitly in the csproj
// as the CommonMerged.d.ts is generated at build-time.
// If we reference them here, TSC 1.8.10 includes the source in the merged JS file
// which is not what we want.
//--------
// <reference path="../../common/controls/componentModel.ts" />
// <reference path="../../common/controls/templateControl.ts" />
//--------
/// <reference path="CollectionView.ts" />
var MemoryProfiler;
(function (MemoryProfiler) {
    "use strict";
    var TakeSnapshotTask = (function () {
        function TakeSnapshotTask(controller) {
            this._snapshotAgents = [];
            this._controller = controller;
            this._snapshotAgents.push(new MemoryProfiler.Common.ClrSnapshotAgent());
            this._snapshotAgents.push(new MemoryProfiler.Common.ScreenshotSnapshotAgent());
        }
        TakeSnapshotTask.prototype.start = function () {
            var _this = this;
            return new Microsoft.Plugin.Promise(function (completed, error) {
                if (!_this.takeSnapshotInternal()) {
                    if (error) {
                        error(new Error("Snapshot Not Currently Enabled"));
                    }
                }
                else {
                    _this._snapshotCompleted = completed;
                    _this._snapshotError = error;
                }
            });
        };
        TakeSnapshotTask.prototype.isCompleted = function (message) {
            if (message) {
                var obj = JSON.parse(message);
                if (obj.eventName) {
                    if (obj.eventName === "snapshotData") {
                        if (this._controller.model.isViewBusy) {
                            var snapshotData = obj;
                            if (this._activeSnapshot && snapshotData.id == this._activeSnapshot.id) {
                                this._activeSnapshot.processAgentData(snapshotData.data.agent, snapshotData.data.data);
                            }
                        }
                    }
                }
                else {
                    if (this._controller.model.isViewBusy) {
                        if (obj.snapshotResults) {
                            this.onSnapshotResult(obj);
                        }
                        else {
                            var response = obj;
                            this.onSnapshotFailed(new Error(response.errorMessage));
                        }
                        return true;
                    }
                }
            }
            return false;
        };
        TakeSnapshotTask.prototype.takeSnapshotInternal = function () {
            if (this._controller.model.isViewBusy) {
                return false;
            }
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logCommandUsage(MemoryProfiler.Common.FeedbackCommandNames.TakeSnapshot, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Control, MemoryProfiler.Common.FeedbackCommandSourceNames.CollectionView);
            MemoryProfiler.Common.MemoryProfilerViewHost.startCodeMarker(MemoryProfiler.Common.CodeMarkerValues.perfMP_TakeSnapshotStart, MemoryProfiler.Common.CodeMarkerValues.perfMP_TakeSnapshotEnd);
            this._controller.model.isTakingSnapshot = true;
            this._activeSnapshot = new MemoryProfiler.Common.SnapshotEngine(MemoryProfiler.CollectionViewController._nextIdentifier, this._snapshotAgents, this._controller);
            var message = "{ \"commandName\": \"takeSnapshot\", \"snapshotId\": \"" + MemoryProfiler.CollectionViewController._nextIdentifier + "\", \"agentMask\": \"65535\" }";
            this._controller.sendMessage(message);
            return true;
        };
        TakeSnapshotTask.prototype.onSnapshotResult = function (snapshotResult) {
            var _this = this;
            if (!snapshotResult) {
                throw new Error("<move to resources>: snapshotAsync ended with no response");
            }
            if (!this._activeSnapshot) {
                this._controller.model.isTakingSnapshot = false;
            }
            else {
                this._activeSnapshot.processSnapshotResults(snapshotResult.snapshotResults, function (snapshot) {
                    MemoryProfiler.Common.MemoryProfilerViewHost.session.addSnapshot(snapshot).then(function () {
                        _this.onSnapshotCompleted(_this._activeSnapshot.snapshot);
                    });
                }, this.onSnapshotFailed);
            }
        };
        TakeSnapshotTask.prototype.onSnapshotCompleted = function (snapshot) {
            if (this._snapshotCompleted) {
                this._snapshotCompleted(Microsoft.Plugin.Promise.wrap(snapshot));
            }
            this._snapshotCompleted = null;
            this._snapshotError = null;
            if (!snapshot) {
                throw new Error(Microsoft.Plugin.Resources.getErrorString("MemProf.1014"));
            }
            MemoryProfiler.CollectionViewController._nextIdentifier++;
            this._controller.model.snapshotSummaryCollection.add(snapshot);
            this._controller.model.isTakingSnapshot = false;
            this._activeSnapshot = null;
            MemoryProfiler.Common.MemoryProfilerViewHost.endCodeMarker(MemoryProfiler.Common.CodeMarkerValues.perfMP_TakeSnapshotStart);
        };
        TakeSnapshotTask.prototype.onSnapshotFailed = function (error) {
            if (!error) {
                throw new Error(Microsoft.Plugin.Resources.getErrorString("MemProf.1015"));
            }
            error.message = Microsoft.Plugin.Resources.getString("SnapshotCreationFailed", error.message);
            this._controller.model.latestSnapshotError = error;
            this._controller.model.isTakingSnapshot = false;
            this._activeSnapshot = null;
            if (this._snapshotError) {
                this._snapshotError(error);
            }
            this._snapshotCompleted = null;
            this._snapshotError = null;
            MemoryProfiler.Common.MemoryProfilerViewHost.endCodeMarker(MemoryProfiler.Common.CodeMarkerValues.perfMP_TakeSnapshotStart);
            MemoryProfiler.Common.MemoryProfilerViewHost.onIdle();
        };
        return TakeSnapshotTask;
    }());
    MemoryProfiler.TakeSnapshotTask = TakeSnapshotTask;
    var ForceGcCollectionAgentTask = (function () {
        function ForceGcCollectionAgentTask(controller) {
            this._controller = controller;
        }
        ForceGcCollectionAgentTask.prototype.start = function () {
            var _this = this;
            MemoryProfiler.Common.MemoryProfilerViewHost.session.logCommandUsage(MemoryProfiler.Common.FeedbackCommandNames.ForceGarbageCollection, MemoryProfiler.Common.FeedbackCommandInvokeMethodNames.Control, MemoryProfiler.Common.FeedbackCommandSourceNames.CollectionView);
            MemoryProfiler.Common.MemoryProfilerViewHost.startCodeMarker(MemoryProfiler.Common.CodeMarkerValues.prefMP_ForceGarbageCollectionStart, MemoryProfiler.Common.CodeMarkerValues.prefMP_ForceGarbageCollectionEnd);
            return new Microsoft.Plugin.Promise(function (completed) {
                _this._controller.model.isForcingGarbageCollection = true;
                var message = "{ \"commandName\": \"forceGarbageCollection\"}";
                _this._controller.sendMessage(message);
                _this._forceGcCompleted = completed;
            });
        };
        ForceGcCollectionAgentTask.prototype.isCompleted = function (message) {
            var result = false;
            if (message) {
                var obj = JSON.parse(message);
                if (obj.eventName && obj.eventName === "forcedGarbageCollectionComplete") {
                    this._controller.model.isForcingGarbageCollection = false;
                    MemoryProfiler.Common.MemoryProfilerViewHost.endCodeMarker(MemoryProfiler.Common.CodeMarkerValues.prefMP_ForceGarbageCollectionStart);
                    result = true;
                }
            }
            if (this._forceGcCompleted) {
                this._forceGcCompleted();
            }
            this._forceGcCompleted = null;
            return result;
        };
        return ForceGcCollectionAgentTask;
    }());
    MemoryProfiler.ForceGcCollectionAgentTask = ForceGcCollectionAgentTask;
})(MemoryProfiler || (MemoryProfiler = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
//--------
// External CommonMerged references.  These are included explicitly in the csproj
// as the CommonMerged.d.ts is generated at build-time.
// If we reference them here, TSC 1.8.10 includes the source in the merged JS file
// which is not what we want.
//--------
// <reference path="../../Common/controls/componentModel.ts" />
//--------
/// <reference path="../../../../../Common/Script/Hub/plugin.redirect.d.ts" />
/// <reference path="CollectionViewHost.ts" />
var MemoryProfiler;
(function (MemoryProfiler) {
    "use strict";
    var CommandBase = (function (_super) {
        __extends(CommandBase, _super);
        function CommandBase(host, commandBinding) {
            _super.call(this, commandBinding);
            this._host = host;
        }
        CommandBase.prototype.setNext = function (nextCommand) {
            this._nextCommand = nextCommand;
        };
        CommandBase.prototype.onCollectionFinishing = function () {
            this.setEnabled(false);
            if (this._nextCommand) {
                this._nextCommand.onCollectionFinishing();
            }
        };
        CommandBase.prototype.onTargetIsManaged = function () {
            if (this._nextCommand) {
                this._nextCommand.onTargetIsManaged();
            }
        };
        CommandBase.prototype.onPropertyChanged = function (propertyName) {
            if (propertyName === "isViewBusy") {
                this.setEnabled(this.shouldEnable());
            }
            if (this._nextCommand) {
                this._nextCommand.onPropertyChanged(propertyName);
            }
        };
        CommandBase.prototype.onClose = function () {
            this.setEnabled(false);
            if (this._nextCommand) {
                this._nextCommand.onClose();
            }
        };
        CommandBase.prototype.shouldEnable = function () {
            return !this._host.collectionViewController.model.isViewBusy;
        };
        return CommandBase;
    }(Microsoft.VisualStudio.DiagnosticsHub.ToolbarButton));
    MemoryProfiler.CommandBase = CommandBase;
    var TakeSnapshotCommand = (function (_super) {
        __extends(TakeSnapshotCommand, _super);
        function TakeSnapshotCommand(host) {
            _super.call(this, host, {
                callback: function () { return host.collectionViewController.takeSnapshot(); },
                label: Microsoft.Plugin.Resources.getString("TakeSnapshot"),
                iconEnabled: "image-snapshot",
                iconDisabled: "image-snapshot-disabled",
                disabled: function () { return host.collectionViewController.model.isViewBusy; },
                displayOnToolbar: true
            });
        }
        return TakeSnapshotCommand;
    }(CommandBase));
    MemoryProfiler.TakeSnapshotCommand = TakeSnapshotCommand;
    var ForceGcCommand = (function (_super) {
        __extends(ForceGcCommand, _super);
        function ForceGcCommand(host) {
            _super.call(this, host, {
                callback: function () { return host.collectionViewController.forceGarbageCollection(); },
                label: Microsoft.Plugin.Resources.getString("ForceGc"),
                iconEnabled: "image-forceGc",
                iconDisabled: "image-forceGc-disabled",
                displayOnToolbar: true
            });
            this.isManaged = false;
            this.setEnabled(false);
            this.container.hidden = true;
        }
        ForceGcCommand.prototype.onTargetIsManaged = function () {
            this.isManaged = true;
            this.setEnabled(this.shouldEnable());
            _super.prototype.onTargetIsManaged.call(this);
        };
        ForceGcCommand.prototype.shouldEnable = function () {
            return this.isManaged && _super.prototype.shouldEnable.call(this);
        };
        return ForceGcCommand;
    }(CommandBase));
    MemoryProfiler.ForceGcCommand = ForceGcCommand;
})(MemoryProfiler || (MemoryProfiler = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
//--------
// External CommonMerged references.  These are included explicitly in the csproj
// as the CommonMerged.d.ts is generated at build-time.
// If we reference them here, TSC 1.8.10 includes the source in the merged JS file
// which is not what we want.
//--------
// <reference path="../../Common/Extensions/Session.ts" />
// <reference path="../../Common/controls/control.ts" />
// <reference path="../../Common/controls/componentModel.ts" />
// <reference path="../../Common/Profiler/MemoryProfilerViewHost.ts" />
//--------
/// <reference path="../../../../../common/script/Hub/Plugin.redirect.d.ts" />
/// <reference path="../../../../../common/script/Hub/DiagnosticsHub.redirect.d.ts" />
/// <reference path="CollectionView.ts" />
/// <reference path="VsPluginCommandHelper.ts" />
var MemoryProfiler;
(function (MemoryProfiler) {
    "use strict";
    var CollectionViewHost = (function (_super) {
        __extends(CollectionViewHost, _super);
        function CollectionViewHost() {
            _super.call(this);
        }
        CollectionViewHost.prototype.sessionStateChanged = function (eventArgs) {
            var currentState = eventArgs.currentState;
            switch (currentState) {
                case 400 /* CollectionFinishing */:
                    CollectionViewHost.CommandChain.onCollectionFinishing();
                    break;
                case 500 /* CollectionFinished */:
                    Microsoft.VisualStudio.DiagnosticsHub.getCurrentSession().removeStateChangedEventListener(this.sessionStateChanged);
                    // Have session persist our session metadata now
                    var eventCompleteDeferral = eventArgs.getDeferral();
                    var onSaveCompleted = function (success) {
                        eventCompleteDeferral.complete();
                    };
                    this.session.save(this.collectionViewController.managedDataSeen === true).done(onSaveCompleted);
                    break;
            }
        };
        CollectionViewHost.prototype.onPropertyChanged = function (propertyName) {
            CollectionViewHost.CommandChain.onPropertyChanged(propertyName);
        };
        CollectionViewHost.prototype.initializeView = function (sessionInfo) {
            this.collectionViewController = new MemoryProfiler.CollectionViewController();
            document.getElementById('mainContainer').appendChild(this.collectionViewController.view.rootElement);
            this.collectionViewController.model.registerPropertyChanged(this);
            Microsoft.VisualStudio.DiagnosticsHub.getCurrentSession().addStateChangedEventListener(this.sessionStateChanged.bind(this));
            Microsoft.Plugin.addEventListener("close", function () {
                CollectionViewHost.CommandChain.onClose();
            });
            this.initCommands();
        };
        CollectionViewHost.prototype.initCommands = function () {
            if (Microsoft.Plugin.VS && Microsoft.Plugin.VS.Commands) {
                var takeSnapshotCommand = new MemoryProfiler.TakeSnapshotCommand(this);
                var forceGcCommand = new MemoryProfiler.ForceGcCommand(this);
                takeSnapshotCommand.setNext(forceGcCommand);
                CollectionViewHost.CommandChain = takeSnapshotCommand;
                var toolbarSection = document.getElementsByClassName('toolbarSection')[0];
                var toolbar = new Microsoft.VisualStudio.DiagnosticsHub.Toolbar();
                toolbar.addToolbarItem(takeSnapshotCommand);
                toolbar.addToolbarItem(forceGcCommand);
                toolbarSection.appendChild(toolbar.container);
            }
        };
        return CollectionViewHost;
    }(MemoryProfiler.Common.MemoryProfilerViewHostBase));
    MemoryProfiler.CollectionViewHost = CollectionViewHost;
    MemoryProfiler.CollectionViewHostInstance = new CollectionViewHost();
})(MemoryProfiler || (MemoryProfiler = {}));
MemoryProfiler.CollectionViewHostInstance.loadView();
//# sourceMappingURL=CollectionViewMerged.js.map
// SIG // Begin signature block
// SIG // MIIkFgYJKoZIhvcNAQcCoIIkBzCCJAMCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // isZ5GIF7TzM7+dKWVrCn99XvBWfr+4RoA7KZ+Bjmquyg
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFdswghXXAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggcYwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIMLAir/7THSodQ+RBzc7IE/nUmvtqym5KwOhfKTw
// SIG // Run0MFoGCisGAQQBgjcCAQwxTDBKoDCALgBDAG8AbABs
// SIG // AGUAYwB0AGkAbwBuAFYAaQBlAHcATQBlAHIAZwBlAGQA
// SIG // LgBqAHOhFoAUaHR0cDovL21pY3Jvc29mdC5jb20wDQYJ
// SIG // KoZIhvcNAQEBBQAEggEAAjmWSu6fsWmbDLDvHf1N3DR9
// SIG // INqrQMqt3dWrWUUcYBze7dxAi+UZ4AD/+pIuY6YJtHUT
// SIG // 0v1obDObrD7/glpHkohdXy5BuEGWYAF0XE7DSfP/P19P
// SIG // LsWcEn2uOzUi7XHj0N76YMSxj+VqHvhf0zcqKzboxjfP
// SIG // zOFV3zrXbEVdqpcvYSAn6RQ3cUGUH4v6uOh7su6+Qiqk
// SIG // tUj3R8W3JFQnE6of0fTJ8Nj3/BpEcoZ0W6+YFWox9Ksa
// SIG // JHqJY32yU6De9ngNKEBwYVQHKMeDXXCCxCGFeGXxfn8j
// SIG // NZVqwOyXXCfvgGkl8c7Dj8qM9kppooaKhF4adEcSTXxK
// SIG // DwnCx6/N4aGCE00wghNJBgorBgEEAYI3AwMBMYITOTCC
// SIG // EzUGCSqGSIb3DQEHAqCCEyYwghMiAgEDMQ8wDQYJYIZI
// SIG // AWUDBAIBBQAwggE9BgsqhkiG9w0BCRABBKCCASwEggEo
// SIG // MIIBJAIBAQYKKwYBBAGEWQoDATAxMA0GCWCGSAFlAwQC
// SIG // AQUABCAt1mX6SfEUmnV/8giDWx9Idlh2mXsCMpa9ibPj
// SIG // vaMNkAIGWIuRnbEeGBMyMDE3MDIwOTAzNDMzNy43MjVa
// SIG // MAcCAQGAAgH0oIG5pIG2MIGzMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lw
// SIG // aGVyIERTRSBFU046OThGRC1DNjFFLUU2NDExJTAjBgNV
// SIG // BAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2Wg
// SIG // gg7QMIIGcTCCBFmgAwIBAgIKYQmBKgAAAAAAAjANBgkq
// SIG // hkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQx
// SIG // HjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEy
// SIG // MDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNh
// SIG // dGUgQXV0aG9yaXR5IDIwMTAwHhcNMTAwNzAxMjEzNjU1
// SIG // WhcNMjUwNzAxMjE0NjU1WjB8MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFt
// SIG // cCBQQ0EgMjAxMDCCASIwDQYJKoZIhvcNAQEBBQADggEP
// SIG // ADCCAQoCggEBAKkdDbx3EYo6IOz8E5f1+n9plGt0VBDV
// SIG // pQoAgoX77XxoSyxfxcPlYcJ2tz5mK1vwFVMnBDEfQRsa
// SIG // lR3OCROOfGEwWbEwRA/xYIiEVEMM1024OAizQt2TrNZz
// SIG // MFcmgqNFDdDq9UeBzb8kYDJYYEbyWEeGMoQedGFnkV+B
// SIG // VLHPk0ySwcSmXdFhE24oxhr5hoC732H8RsEnHSRnEnIa
// SIG // IYqvS2SJUGKxXf13Hz3wV3WsvYpCTUBR0Q+cBj5nf/Vm
// SIG // wAOWRH7v0Ev9buWayrGo8noqCjHw2k4GkbaICDXoeByw
// SIG // 6ZnNPOcvRLqn9NxkvaQBwSAJk3jN/LzAyURdXhacAQVP
// SIG // Ik0CAwEAAaOCAeYwggHiMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBTVYzpcijGQ80N7fEYbxTNoWoVtVTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBTV9lbLj+iiXGJo0T2UkFvXzpoYxDBWBgNVHR8ETzBN
// SIG // MEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXRfMjAx
// SIG // MC0wNi0yMy5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsG
// SIG // AQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NlcnRzL01pY1Jvb0NlckF1dF8yMDEwLTA2LTIz
// SIG // LmNydDCBoAYDVR0gAQH/BIGVMIGSMIGPBgkrBgEEAYI3
// SIG // LgMwgYEwPQYIKwYBBQUHAgEWMWh0dHA6Ly93d3cubWlj
// SIG // cm9zb2Z0LmNvbS9QS0kvZG9jcy9DUFMvZGVmYXVsdC5o
// SIG // dG0wQAYIKwYBBQUHAgIwNB4yIB0ATABlAGcAYQBsAF8A
// SIG // UABvAGwAaQBjAHkAXwBTAHQAYQB0AGUAbQBlAG4AdAAu
// SIG // IB0wDQYJKoZIhvcNAQELBQADggIBAAfmiFEN4sbgmD+B
// SIG // cQM9naOhIW+z66bM9TG+zwXiqf76V20ZMLPCxWbJat/1
// SIG // 5/B4vceoniXj+bzta1RXCCtRgkQS+7lTjMz0YBKKdsxA
// SIG // QEGb3FwX/1z5Xhc1mCRWS3TvQhDIr79/xn/yN31aPxzy
// SIG // mXlKkVIArzgPF/UveYFl2am1a+THzvbKegBvSzBEJCI8
// SIG // z+0DpZaPWSm8tv0E4XCfMkon/VWvL/625Y4zu2JfmttX
// SIG // QOnxzplmkIz/amJ/3cVKC5Em4jnsGUpxY517IW3DnKOi
// SIG // PPp/fZZqkHimbdLhnPkd/DjYlPTGpQqWhqS9nhquBEKD
// SIG // uLWAmyI4ILUl5WTs9/S/fmNZJQ96LjlXdqJxqgaKD4kW
// SIG // umGnEcua2A5HmoDF0M2n0O99g/DhO3EJ3110mCIIYdqw
// SIG // UB5vvfHhAN/nMQekkzr3ZUd46PioSKv33nJ+YWtvd6mB
// SIG // y6cJrDm77MbL2IK0cs0d9LiFAR6A+xuJKlQ5slvayA1V
// SIG // mXqHczsI5pgt6o3gMy4SKfXAL1QnIffIrE7aKLixqduW
// SIG // sqdCosnPGUFN4Ib5KpqjEWYw07t0MkvfY3v1mYovG8ch
// SIG // r1m1rtxEPJdQcdeh0sVV42neV8HR3jDA/czmTfsNv11P
// SIG // 6Z0eGTgvvM9YBS7vDaBQNdrvCScc1bN+NR4Iuto229Nf
// SIG // j950iEkSMIIE2jCCA8KgAwIBAgITMwAAAJ0gnFZ3VdQo
// SIG // mgAAAAAAnTANBgkqhkiG9w0BAQsFADB8MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBQQ0EgMjAxMDAeFw0xNjA5MDcxNzU2NDFa
// SIG // Fw0xODA5MDcxNzU2NDFaMIGzMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lw
// SIG // aGVyIERTRSBFU046OThGRC1DNjFFLUU2NDExJTAjBgNV
// SIG // BAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2Uw
// SIG // ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDS
// SIG // RJicEVoqGi6qn1NdbV28tll2kcAmWwPmyGxfoyrrTABG
// SIG // dDgUvyp4XbAjTOxuYEjsSeRbdaZw/fPUrlVujr0EH2c9
// SIG // Gf0xcoKUoXOxLrzwHNTb7yG4xqm0xsJGBy6ZzD4hC8Mu
// SIG // SN8ManXFNY7XWZyrO0h+nrLg/FSW3hNHOULQbtZL/b8M
// SIG // pPAL5froyIiL7pz7deHES+jLDmTOV95gqHpKzmUcuGWW
// SIG // I2I7fwVPWWbd6Q3V+Hy+wEzeewqWG8xVOQRvBghBOLv1
// SIG // Gd+1egR3BRzi7IzH8bGaXkduzLIeo9qWeIHu8AeYgFG+
// SIG // ugoUHn6eOlkkoVdzDP5BRE6WwlRRD6nFAgMBAAGjggEb
// SIG // MIIBFzAdBgNVHQ4EFgQUvIYIyltqWsrkvczLgrQVSOqH
// SIG // 5aEwHwYDVR0jBBgwFoAU1WM6XIoxkPNDe3xGG8UzaFqF
// SIG // bVUwVgYDVR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWlj
// SIG // VGltU3RhUENBXzIwMTAtMDctMDEuY3JsMFoGCCsGAQUF
// SIG // BwEBBE4wTDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNUaW1TdGFQ
// SIG // Q0FfMjAxMC0wNy0wMS5jcnQwDAYDVR0TAQH/BAIwADAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDCDANBgkqhkiG9w0BAQsF
// SIG // AAOCAQEAf94kIb1Z77TWi3HKWZG+LqhGgruP32QdfeYq
// SIG // C7woZ0v++Xe/tfROpP3oSg8+ZyKzVoltlwha7CMU9Xkq
// SIG // E1eMkhedBiHq86jqGzvc24SaS/dyFfafjyeo/6Xi1iCJ
// SIG // lU1AqRVgXrmXAdcwC/9CamtW2exaXDYDgMwWLWrBuTNk
// SIG // T9tea3/Yb8CugaU47TrOXXIajEwVy1+TjLLdqgAt4/1k
// SIG // KKmpvhAd/hXcJ48fjqQD6o432wQlUx/hMnr3OyKQzNwq
// SIG // DcFehgnVPlbvqyWgessyQFj2vQlbtsn/e0d5dIalhp3Y
// SIG // Ig1XXuGoDcYmTgL2/Tr2Aaz3l7y5kQ5h253T76Y2aaGC
// SIG // A3kwggJhAgEBMIHjoYG5pIG2MIGzMQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5u
// SIG // Q2lwaGVyIERTRSBFU046OThGRC1DNjFFLUU2NDExJTAj
// SIG // BgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZp
// SIG // Y2WiJQoBATAJBgUrDgMCGgUAAxUAGA2ss4xoMLP4dBmy
// SIG // eM6AKzUvCPqggcIwgb+kgbwwgbkxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdS
// SIG // ZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9y
// SIG // YXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5D
// SIG // aXBoZXIgTlRTIEVTTjo1N0Y2LUMxRTAtNTU0QzErMCkG
// SIG // A1UEAxMiTWljcm9zb2Z0IFRpbWUgU291cmNlIE1hc3Rl
// SIG // ciBDbG9jazANBgkqhkiG9w0BAQUFAAIFANxFzFcwIhgP
// SIG // MjAxNzAyMDgxNjU2NTVaGA8yMDE3MDIwOTE2NTY1NVow
// SIG // dzA9BgorBgEEAYRZCgQBMS8wLTAKAgUA3EXMVwIBADAK
// SIG // AgEAAgIAiAIB/zAHAgEAAgImfjAKAgUA3Ecd1wIBADA2
// SIG // BgorBgEEAYRZCgQCMSgwJjAMBgorBgEEAYRZCgMBoAow
// SIG // CAIBAAIDFuNgoQowCAIBAAIDB6EgMA0GCSqGSIb3DQEB
// SIG // BQUAA4IBAQBioAjKyLK796yVmb8s7ZryGQO8Vtq/Ix+f
// SIG // 5sHcauNS5RO2H7g1W8Cdni7DA/P5Hk6LDQIHqIRkK5JE
// SIG // 6sgkmBiuVbnt5/od5bAaVrHv8ZZh0uoYP0WU5MT/AFaI
// SIG // mPR6rwQnr8SOAc7i6buY+h60ACtZbPMCpCooVYp3EyOq
// SIG // sc/HhqT90TMsQtxtPEcz7/WiVdIvjQCyLHYsE/gAyrhn
// SIG // VDJ6qvHIp+0yn+ApeN2KUkYnX+/WEtKDDkq6hC8cfRAF
// SIG // rHlFDA44wnYazOf7tuuLwEAJIbh/W9Pw/LsSqaijKxh0
// SIG // KX2AtB+E32LXU2M+Annp9mA65Tpd6NbegKdXyZufbBGO
// SIG // MYIC9TCCAvECAQEwgZMwfDELMAkGA1UEBhMCVVMxEzAR
// SIG // BgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
// SIG // bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
// SIG // bjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAg
// SIG // UENBIDIwMTACEzMAAACdIJxWd1XUKJoAAAAAAJ0wDQYJ
// SIG // YIZIAWUDBAIBBQCgggEyMBoGCSqGSIb3DQEJAzENBgsq
// SIG // hkiG9w0BCRABBDAvBgkqhkiG9w0BCQQxIgQgG/jPOzGv
// SIG // k02brvLHHmUKdatYXPZS7snyn6h00wyNmNYwgeIGCyqG
// SIG // SIb3DQEJEAIMMYHSMIHPMIHMMIGxBBQYDayzjGgws/h0
// SIG // GbJ4zoArNS8I+jCBmDCBgKR+MHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdS
// SIG // ZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9y
// SIG // YXRpb24xJjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0
// SIG // YW1wIFBDQSAyMDEwAhMzAAAAnSCcVndV1CiaAAAAAACd
// SIG // MBYEFMXAFdX+vRcjQ820Rqmgae4nQmLbMA0GCSqGSIb3
// SIG // DQEBCwUABIIBAEUml34bdmGxBx2LVKT32uPArDt99YyY
// SIG // g07OrqticjXvF74lBzKnl1t4t3XgtVATvAu+XpUQw2S3
// SIG // UXwkvy/7cLmtlYZ5u13mDaTMHSLXUH+FROiy4Dj9kdLn
// SIG // Wo2siNsgn/CApHPskuzs/abonnDS8W60qgujqxdoSkVs
// SIG // WJQg1VcG6QMHSfoDXJxC+Wtx+Qw/C8pnC27ImeL0PJAK
// SIG // c8dJWHuWIRWUamriPijXEBC/UFbado4tlFCCbVF2VlIL
// SIG // GmBgx+spiXuB+t5bmCbLV8q5wMV3jMXR8LSSyasOkAzS
// SIG // OVad/Idbb3iT+ZYIR3atdfYDvFnD0kvsbT9W9JAcstU07gg=
// SIG // End signature block
